package controller;

import model.User;
import model.LoginAttemptLogger;
import service.UserService;

import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.*;
import java.io.IOException;

//@WebServlet("/login")
public class LoginServlet extends HttpServlet {
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String email = request.getParameter("email");
        String password = request.getParameter("password");

        User user = UserService.authenticate(email, password);
        if (user != null) {
            request.getSession().setAttribute("user", user);
            LoginAttemptLogger.getInstance().log(email, true, "Login successful");
            response.sendRedirect("home.jsp");
        } else {
	    LoginAttemptLogger.getInstance().log(email, false, "Credentials not recognized");
            request.setAttribute("error", "Credentials not recognized");
            request.getRequestDispatcher("login.jsp").forward(request, response);
        }
    }
}