package model;

import java.time.LocalDateTime;

public class LoginAttempt {
    private String email;
    private boolean success;
    private String message;
    private LocalDateTime timestamp;

    public LoginAttempt(String email, boolean success, String message) {
        this.email = email;
        this.success = success;
        this.message = message;
        this.timestamp = LocalDateTime.now();
    }

    public String toString() {
        return timestamp + " - " + email + " - " + (success ? "Success" : "Failure") + " - " + message;
    }

    public String getTimestamp() {
	return timestamp.toString();
    }
    public String getEmail() {
	return email;
    }
    public String getSuccess() {
	return success ? "Success" : "Failure";
    }
    public String getMessage() {
	return message;
    }
}