package model;

import java.util.ArrayList;
import java.util.List;

public class LoginAttemptLogger {
    private static LoginAttemptLogger instance = new LoginAttemptLogger();
    private List<LoginAttempt> attempts = new ArrayList<>();

    private LoginAttemptLogger() {}

    public static LoginAttemptLogger getInstance() {
        return instance;
    }

    public void log(String email, boolean success, String message) {
        attempts.add(new LoginAttempt(email, success, message));
    }

    public List<LoginAttempt> getAttempts() {
        return attempts;
    }
}