<%@ page import="java.util.List" %>
<%@ page import="model.LoginAttemptLogger" %>
<%@ page import="model.LoginAttempt" %>
<%@ page import="model.User" %>
<%@ page import="model.Role" %>
<%
    response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate"); // HTTP 1.1.
    response.setHeader("Pragma", "no-cache"); // HTTP 1.0.
    response.setDateHeader("Expires", 0); // Proxies.

    User user = (User) session.getAttribute("user");
    if (user == null) {
        response.sendRedirect("welcome.jsp");
        return;
    }
    if (user.getRole() != Role.ADMIN) {
    	response.sendRedirect("home.jsp");
    	return;
    }
%>
<%
    List<LoginAttempt> attempts = LoginAttemptLogger.getInstance().getAttempts();
%>
<!DOCTYPE html>
<html>
<head>
    <title>Login Report</title>
    <link rel="stylesheet" href="style/style.css">
</head>
<body>
    <table>
	    <tr id="table_header_row">
	        <td align="center">
<h1>Login Attempts</h1>
	        </td>
	    </tr><tr id="table_image_row">
	        <td align="center">
<img src="images/spaceship.png" alt="1950s spaceship">
	        </td>
	    </tr><tr id="table_content_row2">
    		<td align="center">
		    <table align="center">
		        <tr>
			    <td><strong>Timestamp</strong></td>
			    <td><strong>Email</strong></td>
			    <td><strong>Status</strong></td>
			    <td><strong>Message</strong></td>
		        </tr>
		    <!-- put rows in here -->
<% for (LoginAttempt a : attempts) { %>
        <tr>
	    <td><%= a.getTimestamp() %></td>
	    <td><%= a.getEmail() %></td>
	    <td><%= a.getSuccess() %></td>
	    <td><%= a.getMessage() %></td>
	</tr>	    
<% } %>
		</table>		
	    </td>
	</tr>
    </table>
    <form action="home.jsp" method="get">
	    <table>
	        <tr id="table_button_row">
        	    <td align="center">
 <button type="submit">Return to Home page</button>
		        </td>
	        </tr>
	    </table>
    </form>
</body>
</html>